/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package com.etl.pdfsigner;
import java.awt.*;
import javax.swing.*;
import java.io.File;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.DefaultListModel;
import com.abcprocure.crypto.*;
import com.itextpdf.text.Element;
import com.itextpdf.text.Image;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.pdf.ColumnText;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfGState;
import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.PdfSignatureAppearance;
import com.itextpdf.text.pdf.PdfStamper;
import com.itextpdf.text.pdf.PdfTemplate;
import com.itextpdf.text.pdf.security.BouncyCastleDigest;
import com.itextpdf.text.pdf.security.DigestAlgorithms;
import com.itextpdf.text.pdf.security.ExternalDigest;
import com.itextpdf.text.pdf.security.ExternalSignature;
import com.itextpdf.text.pdf.security.MakeSignature;
import com.itextpdf.text.pdf.security.MakeSignature.CryptoStandard;
import com.itextpdf.text.pdf.security.PrivateKeySignature;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.AcroFields;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.HttpsURLConnection;

import org.json.JSONObject;
/**
 *
 * @author ashutosh.p/*
 */
public class PDFSigner extends javax.swing.JFrame {
    private ABCCertificateUtility Certutility = new ABCCertificateUtility();
    private int iCertCount = 0;
    private String certAlias = "";
    private String certSerial = "";
    private KeyStore ks = null;
    HashMap<Integer, String> certAliasMap = new HashMap<Integer, String>();
    ResourceBundle resourceBundle = null;
    JSONObject certAliasSerial = new JSONObject();
    private com.itextpdf.text.Font fontphrase = new com.itextpdf.text.Font(com.itextpdf.text.Font.FontFamily.TIMES_ROMAN, 18, Font.BOLD);
    /**
     * Creates new form PDFSigner
     */
    public PDFSigner() {
        Font fontHeader = new Font("Courier", Font.BOLD,16);
        this.setSize(200, 100);
        this.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        this.setFont(fontHeader);
        this.setTitle("ETL PDF Signer Component");
        this.setVisible(true);
        loadCerti();
        initComponents();
        setIcon();
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jScrollPane1 = new javax.swing.JScrollPane();
        jTextArea1 = new javax.swing.JTextArea();
        jMenuItem1 = new javax.swing.JMenuItem();
        jMenuItem2 = new javax.swing.JMenuItem();
        jCheckBoxMenuItem1 = new javax.swing.JCheckBoxMenuItem();
        jMenuItem3 = new javax.swing.JMenuItem();
        jMenuItem4 = new javax.swing.JMenuItem();
        jMenuItem5 = new javax.swing.JMenuItem();
        jCheckBoxMenuItem2 = new javax.swing.JCheckBoxMenuItem();
        jMenuItem6 = new javax.swing.JMenuItem();
        jPopupMenu1 = new javax.swing.JPopupMenu();
        jRadioButtonMenuItem1 = new javax.swing.JRadioButtonMenuItem();
        jCheckBoxMenuItem3 = new javax.swing.JCheckBoxMenuItem();
        jMenuItem7 = new javax.swing.JMenuItem();
        jMenu1 = new javax.swing.JMenu();
        jLabel11 = new javax.swing.JLabel();
        jLabel1 = new javax.swing.JLabel();
        jButton1 = new javax.swing.JButton();
        jButton2 = new javax.swing.JButton();
        jTextField1 = new javax.swing.JTextField();
        jButton4 = new javax.swing.JButton();
        jLabel2 = new javax.swing.JLabel();
        jScrollPane2 = new javax.swing.JScrollPane();
        jList1 = new javax.swing.JList<>();
        jLabel4 = new javax.swing.JLabel();
        jComboBox1 = new javax.swing.JComboBox<>();
        jLabel12 = new javax.swing.JLabel();
        jComboBox2 = new javax.swing.JComboBox<>();
        jLabel13 = new javax.swing.JLabel();
        jLabel14 = new javax.swing.JLabel();
        jComboBox3 = new javax.swing.JComboBox<>();
        jPanel3 = new javax.swing.JPanel();
        jScrollPane3 = new javax.swing.JScrollPane();
        jTable1 = new javax.swing.JTable();
        jPanel1 = new javax.swing.JPanel();
        jCheckBox1 = new javax.swing.JCheckBox();
        jPanel2 = new javax.swing.JPanel();
        jTextField2 = new javax.swing.JTextField();
        jButton5 = new javax.swing.JButton();
        jTextField3 = new javax.swing.JTextField();
        jLabel16 = new javax.swing.JLabel();
        jLabel15 = new javax.swing.JLabel();
        jLabel3 = new javax.swing.JLabel();
        jTextField4 = new javax.swing.JTextField();
        jButton3 = new javax.swing.JButton();

        jTextArea1.setColumns(20);
        jTextArea1.setRows(5);
        jScrollPane1.setViewportView(jTextArea1);

        jMenuItem1.setText("jMenuItem1");

        jMenuItem2.setText("jMenuItem2");

        jCheckBoxMenuItem1.setSelected(true);
        jCheckBoxMenuItem1.setText("jCheckBoxMenuItem1");

        jMenuItem3.setText("jMenuItem3");

        jMenuItem4.setText("jMenuItem4");

        jMenuItem5.setText("jMenuItem5");

        jCheckBoxMenuItem2.setSelected(true);
        jCheckBoxMenuItem2.setText("jCheckBoxMenuItem2");

        jMenuItem6.setText("jMenuItem6");

        jRadioButtonMenuItem1.setSelected(true);
        jRadioButtonMenuItem1.setText("jRadioButtonMenuItem1");

        jCheckBoxMenuItem3.setSelected(true);
        jCheckBoxMenuItem3.setText("jCheckBoxMenuItem3");

        jMenuItem7.setText("jMenuItem7");

        jMenu1.setText("jMenu1");

        jLabel11.setText("jLabel11");

        setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);
        setResizable(false);
        getContentPane().setLayout(new org.netbeans.lib.awtextra.AbsoluteLayout());

        Font font1 = new Font("Courier", Font.BOLD,14);

        jLabel1.setFont(font1);
        jLabel1.setFont(new java.awt.Font("Verdana", 0, 11)); // NOI18N
        jLabel1.setText("PDF Files(s) For Signature:(Allowable file size limit: 50 MB)");
        getContentPane().add(jLabel1, new org.netbeans.lib.awtextra.AbsoluteConstraints(10, 70, 450, -1));

        jButton1.setFont(new java.awt.Font("Verdana", 0, 11)); // NOI18N
        jButton1.setText("Browse file(s)");
        jButton1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton1ActionPerformed(evt);
            }
        });
        getContentPane().add(jButton1, new org.netbeans.lib.awtextra.AbsoluteConstraints(590, 100, 110, -1));

        jButton2.setFont(new java.awt.Font("Verdana", 0, 11)); // NOI18N
        jButton2.setText("Remove file(s)");
        jButton2.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton2ActionPerformed(evt);
            }
        });
        getContentPane().add(jButton2, new org.netbeans.lib.awtextra.AbsoluteConstraints(590, 160, 110, -1));

        jTextField1.setFont(new java.awt.Font("Verdana", 0, 11)); // NOI18N
        jTextField1.setText("");
        jTextField1.setEditable(false);
        getContentPane().add(jTextField1, new org.netbeans.lib.awtextra.AbsoluteConstraints(10, 350, 300, -1));

        jButton4.setFont(new java.awt.Font("Verdana", 0, 11)); // NOI18N
        jButton4.setText("Start Process");
        jButton4.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton4ActionPerformed(evt);
            }
        });
        getContentPane().add(jButton4, new org.netbeans.lib.awtextra.AbsoluteConstraints(260, 560, 143, -1));

        jLabel2.setFont(font1);
        jLabel2.setFont(new java.awt.Font("Verdana", 0, 11)); // NOI18N
        jLabel2.setText("Select Location to Save File(s)");
        getContentPane().add(jLabel2, new org.netbeans.lib.awtextra.AbsoluteConstraints(10, 330, 400, -1));

        jList1.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        jList1.setFont(font1);
        jList1.setFont(new java.awt.Font("Verdana", 0, 11)); // NOI18N
        jList1.setModel(model);
        jScrollPane2.setViewportView(jList1);

        getContentPane().add(jScrollPane2, new org.netbeans.lib.awtextra.AbsoluteConstraints(10, 90, 560, 110));

        jLabel4.setFont(font1);
        jLabel4.setFont(new java.awt.Font("Verdana", 0, 11)); // NOI18N
        jLabel4.setText("Select certificate :");
        getContentPane().add(jLabel4, new org.netbeans.lib.awtextra.AbsoluteConstraints(10, 30, -1, -1));

        Font fontComboBox = new Font("Courier", Font.PLAIN,14);
        jComboBox1.setFont(fontComboBox);
        jComboBox1.setFont(new java.awt.Font("Verdana", 0, 11)); // NOI18N
        jComboBox1.setModel(Combomodel);
        jComboBox1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jComboBox1ActionPerformed(evt);
            }
        });
        getContentPane().add(jComboBox1, new org.netbeans.lib.awtextra.AbsoluteConstraints(180, 30, 330, -1));

        jLabel12.setFont(font1);
        jLabel12.setText("e-Procurement Technologies Limited");
        jLabel12.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        getContentPane().add(jLabel12, new org.netbeans.lib.awtextra.AbsoluteConstraints(230, 600, 350, 30));

        jComboBox2.setFont(new java.awt.Font("Verdana", 0, 11)); // NOI18N
        jComboBox2.setModel(new javax.swing.DefaultComboBoxModel<>(new String[] { "Last Page", "First Page"}));
        jComboBox2.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jComboBox2ActionPerformed(evt);
            }
        });
        getContentPane().add(jComboBox2, new org.netbeans.lib.awtextra.AbsoluteConstraints(210, 280, 220, 30));

        jLabel13.setFont(new java.awt.Font("Verdana", 0, 11)); // NOI18N
        jLabel13.setText("Signature required on :");
        //jLabel13.setFont(font1);
        getContentPane().add(jLabel13, new org.netbeans.lib.awtextra.AbsoluteConstraints(10, 290, -1, -1));

        jLabel14.setFont(new java.awt.Font("Verdana", 0, 11)); // NOI18N
        jLabel14.setText("Select Signature area: ");
        //jLabel14.setFont(font1);
        getContentPane().add(jLabel14, new org.netbeans.lib.awtextra.AbsoluteConstraints(10, 240, -1, -1));

        jComboBox3.setFont(new java.awt.Font("Verdana", 0, 11)); // NOI18N
        jComboBox3.setModel(new javax.swing.DefaultComboBoxModel<>(new String[] { "Bottom -Right","Bottom -Left", "Upper -Right","Upper -Left","Upper-Center","Bottom-Center"}));
        jComboBox3.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jComboBox3ActionPerformed(evt);
            }
        });
        getContentPane().add(jComboBox3, new org.netbeans.lib.awtextra.AbsoluteConstraints(210, 230, 220, 30));

        //jPanel3.setVisible(false);
        jTable1.setFont(new java.awt.Font("Verdana", 0, 11)); // NOI18N
        jTable1.setModel(new javax.swing.table.DefaultTableModel(
            new Object [][] {
                {"Subject:", ""},
                {"Issuer:",  ""},
                {"Valid From:",  ""},
                {"Valid To:",  ""},
                {"Serial:",  ""},
                {"Key Usage :", " "}
            },
            new String [] {
                "Field Name", "Field Value"
            }

        ));
        jTable1.getColumn("Field Value").setPreferredWidth(900);
        jTable1.getColumn("Field Name").setPreferredWidth(90);
        jTable1.getTableHeader().setReorderingAllowed(false);
        jTable1.setDragEnabled(false);
        jTable1.setEnabled(false);
        new JScrollPane(jTable1, JScrollPane.VERTICAL_SCROLLBAR_ALWAYS, JScrollPane.HORIZONTAL_SCROLLBAR_ALWAYS);
        jTable1.setAutoResizeMode(JTable.AUTO_RESIZE_OFF);
        jScrollPane3.setViewportView(jTable1);

        javax.swing.GroupLayout jPanel3Layout = new javax.swing.GroupLayout(jPanel3);
        jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(
            jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel3Layout.createSequentialGroup()
                .addComponent(jScrollPane3, javax.swing.GroupLayout.PREFERRED_SIZE, 682, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(0, 18, Short.MAX_VALUE))
        );
        jPanel3Layout.setVerticalGroup(
            jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, jPanel3Layout.createSequentialGroup()
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addComponent(jScrollPane3, javax.swing.GroupLayout.PREFERRED_SIZE, 140, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(29, 29, 29))
        );

        jPanel3.setVisible(true);

        getContentPane().add(jPanel3, new org.netbeans.lib.awtextra.AbsoluteConstraints(10, 390, 700, 170));

        jCheckBox1.setFont(new java.awt.Font("Verdana", 0, 11)); // NOI18N
        jCheckBox1.setText("click for Yes(✓)");
        jCheckBox1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jCheckBox1ActionPerformed(evt);
            }
        });

        jTextField2.setFont(new java.awt.Font("Verdana", 0, 11)); // NOI18N
        jTextField2.setText("");
        jTextField2.setEditable(false);

        jButton5.setFont(new java.awt.Font("Verdana", 0, 11)); // NOI18N
        jButton5.setText("Browse");
        jButton5.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton5ActionPerformed(evt);
            }
        });

        jTextField3.setFont(new java.awt.Font("Verdana", 0, 11)); // NOI18N
        jTextField3.setText("");

        jLabel16.setFont(new java.awt.Font("Verdana", 0, 11)); // NOI18N
        jLabel16.setText("Remarks:");
        jLabel16.setFont(font1);

        jLabel15.setFont(new java.awt.Font("Verdana", 0, 11)); // NOI18N
        jLabel15.setText("Do you want to upload signature image?");
        jLabel15.setFont(font1);

        javax.swing.GroupLayout jPanel2Layout = new javax.swing.GroupLayout(jPanel2);
        jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(
            jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel2Layout.createSequentialGroup()
                .addGap(14, 14, 14)
                .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(jPanel2Layout.createSequentialGroup()
                        .addComponent(jLabel16, javax.swing.GroupLayout.PREFERRED_SIZE, 90, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                        .addComponent(jTextField3))
                    .addGroup(jPanel2Layout.createSequentialGroup()
                        .addComponent(jTextField2, javax.swing.GroupLayout.PREFERRED_SIZE, 157, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addGap(18, 18, 18)
                        .addComponent(jButton5, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                    .addGroup(jPanel2Layout.createSequentialGroup()
                        .addComponent(jLabel15, javax.swing.GroupLayout.PREFERRED_SIZE, 95, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addGap(0, 0, Short.MAX_VALUE)))
                .addContainerGap())
        );
        jPanel2Layout.setVerticalGroup(
            jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel2Layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jLabel15, javax.swing.GroupLayout.PREFERRED_SIZE, 20, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jTextField2, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jButton5))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel16)
                    .addComponent(jTextField3, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        jPanel2.setVisible(false);

        jLabel3.setFont(new java.awt.Font("Verdana", 0, 11)); // NOI18N
        jLabel3.setText("TenderId  :");
        jLabel3.setFont(font1);

        jTextField4.setFont(new java.awt.Font("Verdana", 0, 11)); // NOI18N
        jTextField4.setText("");
        jTextField4.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jTextField4ActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout jPanel1Layout = new javax.swing.GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel1Layout.createSequentialGroup()
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(jPanel1Layout.createSequentialGroup()
                        .addGap(21, 21, 21)
                        .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(jLabel3, javax.swing.GroupLayout.PREFERRED_SIZE, 100, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addComponent(jTextField4, javax.swing.GroupLayout.PREFERRED_SIZE, 180, javax.swing.GroupLayout.PREFERRED_SIZE))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jCheckBox1, javax.swing.GroupLayout.PREFERRED_SIZE, 110, javax.swing.GroupLayout.PREFERRED_SIZE))
                    .addGroup(jPanel1Layout.createSequentialGroup()
                        .addContainerGap()
                        .addComponent(jPanel2, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)))
                .addContainerGap(9, Short.MAX_VALUE))
        );
        jPanel1Layout.setVerticalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel1Layout.createSequentialGroup()
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jCheckBox1)
                    .addGroup(jPanel1Layout.createSequentialGroup()
                        .addComponent(jLabel3, javax.swing.GroupLayout.PREFERRED_SIZE, 20, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jTextField4, javax.swing.GroupLayout.PREFERRED_SIZE, 30, javax.swing.GroupLayout.PREFERRED_SIZE)))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jPanel2, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap(25, Short.MAX_VALUE))
        );

        getContentPane().add(jPanel1, new org.netbeans.lib.awtextra.AbsoluteConstraints(450, 200, 320, 190));
        jPanel1.setVisible(false);

        jButton3.setFont(new java.awt.Font("Verdana", 0, 11)); // NOI18N
        jButton3.setText("Save file(s) to...");
        jButton3.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton3ActionPerformed(evt);
            }
        });
        getContentPane().add(jButton3, new org.netbeans.lib.awtextra.AbsoluteConstraints(320, 350, 110, -1));

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private boolean sign(String srcFile, String signOnPage ,String  destFolder){
        try {
            KeyStore ks = null;
            ks = KeyStore.getInstance("Windows-MY", "SunMSCAPI");
            ks.load(null, null);
            java.security.cert.Certificate[] chain = ks.getCertificateChain(certAliasMap.get(jComboBox1.getSelectedIndex()));
            PrivateKey key = (PrivateKey) ks.getKey(certAliasMap.get(jComboBox1.getSelectedIndex()), "".toCharArray());
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            PdfReader reader = new PdfReader(srcFile);
            PdfReader.unethicalreading = true;
            PdfStamper stamper = PdfStamper.createSignature(reader, baos, '\0');
            PdfGState gs1 = new PdfGState();
            gs1.setFillOpacity(0.5f);
            PdfContentByte over;
            com.itextpdf.text.Rectangle pagesize = null;
            float x, y;
            
            Phrase phrase;
            phrase = new Phrase("https://canarabank.abcprocure.com");
            Phrase phraseDesclaimer;
            phraseDesclaimer = new Phrase("Desclaimer: Signed document is valid only for Canara Bank.");
            phraseDesclaimer.setFont(fontphrase);
            int pageNum =reader.getNumberOfPages();
            if(signOnPage != null && signOnPage.length() >0){
                if(signOnPage.equals("First Page")){
                  pageNum = 1;  
                }
            }
            for (int i = 1; i <= pageNum; i++) {
                pagesize = reader.getPageSizeWithRotation(i);
                x = (pagesize.getLeft() + pagesize.getRight()) / 2;
                y = (pagesize.getTop() + pagesize.getBottom()) / 2;
                over = stamper.getOverContent(i);
                over.saveState();
                over.setGState(gs1);
                ColumnText.showTextAligned(over, Element.ALIGN_CENTER, phrase, x, y, 45);
                gs1.setFillOpacity(0.5f);
                over.restoreState();
            }
            PdfGState gs2 = new PdfGState();
            gs2.setFillOpacity(2f);
            PdfContentByte over2;
            over2 = stamper.getOverContent(pageNum);
            over2.saveState();
            over2.setGState(gs2);
            
            PdfContentByte over3;
            over3 = stamper.getOverContent(reader.getNumberOfPages());
            over3.saveState();
            over3.setGState(gs2);
            PdfSignatureAppearance appearance = stamper.getSignatureAppearance();
            Rectangle cropBox = reader.getCropBox(1);
            Rectangle rectangle = null;
            float width = 200;
            float height =60;
            int positionId = jComboBox3.getSelectedIndex();
            boolean isImageUpload = false;
            Image img = null;
            if(jCheckBox1.isSelected() && (!jTextField2.getText().isEmpty() && !"".equals(jTextField2.getText()))){
                img = Image.getInstance(jTextField2.getText());
                isImageUpload = true;
            } 
            boolean isUploadRemarks = false;
            Phrase phrase2 = null;
            Phrase phrase3 = null;
            if(!jTextField3.getText().isEmpty() && !"".equals(jTextField3.getText())){
                phrase2 = new Phrase(jTextField3.getText());
                isUploadRemarks = true;
            }
            if(!jTextField4.getText().isEmpty() && !"".equals(jTextField4.getText())){
                phrase3 = new Phrase("Signed for tenderId "+jTextField4.getText());
                isUploadRemarks = true;
            }
            switch (positionId) {
                case 3:
                    // Top left
                    rectangle = new Rectangle(cropBox.getLeft()+10, cropBox.getTop(height),cropBox.getLeft(width)+45, cropBox.getTop()-10);
                    if(isImageUpload){
                        over2.addImage(img, 50, 0, 0, 50, cropBox.getLeft()+50, cropBox.getTop()-50);
                        over2.restoreState();
                    }
                    if(isUploadRemarks){
                        ColumnText.showTextAligned(over3, Element.ALIGN_CENTER, phrase3, cropBox.getLeft()+65, cropBox.getTop()-65,0);
                        if(phrase2 != null){
                            ColumnText.showTextAligned(over3, Element.ALIGN_CENTER, phrase2, cropBox.getLeft()+55, cropBox.getTop()-75,0);
                        }
                        gs1.setFillOpacity(.5f);
                        over3.restoreState();
                    }
                    break;
                case 2:
                    // Top right
                    rectangle = new Rectangle(cropBox.getRight(width), cropBox.getTop(height),cropBox.getRight()-10, cropBox.getTop()-10);
                    if(isImageUpload){
                        over2.addImage(img, 50, 0, 0, 50, cropBox.getRight()-170, cropBox.getTop()-50);
                        over2.restoreState();
                    }
                    if(isUploadRemarks){
                        ColumnText.showTextAligned(over3, Element.ALIGN_CENTER, phrase3, cropBox.getRight()-129, cropBox.getTop()-65, 0);
                        if(phrase2 != null){
                            ColumnText.showTextAligned(over3, Element.ALIGN_CENTER, phrase2, cropBox.getRight()-129, cropBox.getTop()-75, 0);
                        }
                        gs1.setFillOpacity(.5f);
                        over3.restoreState();
                    }
                    break;
                case 1:
                    // Bottom left
                    rectangle = new Rectangle(cropBox.getLeft()+20, cropBox.getBottom()+20,cropBox.getLeft(width)+45, cropBox.getBottom(height));
                    if(isImageUpload){
                        over2.addImage(img, 50, 0, 0, 50, cropBox.getLeft()+50, cropBox.getBottom()+30);
                        over2.restoreState();
                    }
                    if(isUploadRemarks){
                        if(phrase2 != null){
                            ColumnText.showTextAligned(over3, Element.ALIGN_CENTER, phrase2,  cropBox.getLeft()+50, cropBox.getBottom(), 0);
                        }
                        ColumnText.showTextAligned(over3, Element.ALIGN_CENTER, phrase3,  cropBox.getLeft()+90, cropBox.getBottom()+10, 0);
                        gs1.setFillOpacity(.5f);
                        over3.restoreState();
                    }
                    break;
                case 0:
                    // Bottom right
                    rectangle = new Rectangle(cropBox.getRight(width)-45, cropBox.getBottom()+20,cropBox.getRight()-20, cropBox.getBottom(height));
                    if(isImageUpload){
                        over2.addImage(img, 50, 0, 0, 50, cropBox.getRight()-170, cropBox.getBottom()+30);
                        over2.restoreState();
                    }
                    if(isUploadRemarks){
                        if(phrase2 != null){
                            ColumnText.showTextAligned(over3, Element.ALIGN_CENTER, phrase2, cropBox.getRight()-150, cropBox.getBottom()+3, 0);
                        }
                        ColumnText.showTextAligned(over3, Element.ALIGN_CENTER, phrase3, cropBox.getRight()-150, cropBox.getBottom()+13, 0);
                        gs1.setFillOpacity(.5f);
                        over3.restoreState();
                    }
                    break;
                case 4:
                    //Upper - Center
                    rectangle = new Rectangle(((cropBox.getLeft() + cropBox.getRight()) / 2)-70.0f, cropBox.getTop(height),cropBox.getLeft(width)+cropBox.getRight(height)/2, cropBox.getTop()-18);
                    if(isImageUpload){
                        over2.addImage(img, 50, 0, 0, 50, cropBox.getLeft()+250, cropBox.getTop()-50);
                        over2.restoreState();
                    }
                    if(isUploadRemarks){
                        if(phrase2 != null){
                            ColumnText.showTextAligned(over3, Element.ALIGN_CENTER, phrase2, cropBox.getLeft()+300, cropBox.getTop()-77,0);
                        }
                        ColumnText.showTextAligned(over3, Element.ALIGN_CENTER, phrase3, cropBox.getLeft()+300, cropBox.getTop()-67,0);
                        gs1.setFillOpacity(.5f);
                        over3.restoreState();
                    }
                    break;
                case 5:
                    //Bottom-Center
                    rectangle = new Rectangle(((cropBox.getLeft() + cropBox.getRight()) / 2)-70.0f, cropBox.getBottom()+20,cropBox.getLeft(width)+cropBox.getRight(height)/2, cropBox.getBottom(height));
                    if(isImageUpload){
                        over2.addImage(img, 50, 0, 0, 50, cropBox.getLeft()+250,cropBox.getBottom()+40);
                        over2.restoreState();
                    }
                    if(isUploadRemarks){
                        if(phrase2 != null){
                            ColumnText.showTextAligned(over3, Element.ALIGN_CENTER, phrase2, cropBox.getLeft()+300, cropBox.getBottom()+4, 0);
                        }
                        ColumnText.showTextAligned(over3, Element.ALIGN_CENTER, phrase3, cropBox.getLeft()+300, cropBox.getBottom()+14, 0);
                        gs1.setFillOpacity(.5f);
                        over3.restoreState();
          
                    }
                    break;
                default:
                    break;
            }
            //ColumnText.showTextAligned(over3, Element.ALIGN_CENTER, phraseDesclaimer, cropBox.getRight()-150, cropBox.getBottom()+3, 0);
            ColumnText.showTextAligned(over3, Element.ALIGN_CENTER, phraseDesclaimer, cropBox.getLeft()+295, cropBox.getBottom()+5, 0);
            appearance.setVisibleSignature(rectangle, pageNum, "SIGN");
            PdfTemplate n2 = appearance.getLayer(1);
            ColumnText ct = new ColumnText(n2);
            ct.setSimpleColumn(n2.getBoundingBox());
            ct.go();
            ExternalDigest digest = new BouncyCastleDigest();
            ExternalSignature signature = new PrivateKeySignature(key, DigestAlgorithms.SHA1, ks.getProvider().getName());
            MakeSignature.signDetached(appearance,digest,signature,chain,null, null, null,0,CryptoStandard.CMS);
            stamper.close();
            byte[] bytes = baos.toByteArray();
            String fileName = srcFile.substring(srcFile.lastIndexOf("\\")+1, srcFile.length());
            fileName = "sign_"+fileName;
            FileOutputStream pdfw = new java.io.FileOutputStream(destFolder +"\\" + fileName);
	    pdfw.write(bytes);
            pdfw.flush();
            pdfw.close();
        }catch(Exception e){
            System.out.println("error at sign function :"+e);
        }
        return true;
    }
    private void backToInitial(){
        jComboBox1.setSelectedIndex(0);//certi select
        model.removeAllElements();//Empty File Selection list
        //check box
        if(jCheckBox1.isSelected()){
            jCheckBox1.doClick();
            jTextField2.setText("");
            jPanel2.setVisible(false);
        }
        jTextField1.setText("");//destination
        jTextField3.setText("");//remarks
        jComboBox3.setSelectedIndex(0);//signature position
        jComboBox2.setSelectedIndex(0);//page to sign
        jTextField4.setText("");//tenderId
        showEmptyTable();// cert details
    }
    private boolean checkTenderStatus(String tenderId){
        JSONObject tenderStatus = null;
        boolean status = false;
        try{
            resourceBundle = ResourceBundle.getBundle("resource.project");
	    URL urlObj = new URL(resourceBundle.getString("validateTenderURL"));
            //URL urlObj = new URL("http://localhost:8888/EPROC/getTenderStatus");
            System.setProperty("jsse.enableSNIExtension", "false");
            HttpsURLConnection con = (HttpsURLConnection)urlObj.openConnection();
            //HttpURLConnection con = (HttpURLConnection)urlObj.openConnection();
            con.setRequestMethod("POST");
            con.setReadTimeout(0);
            con.setDoInput(true);
            con.setDoOutput(true);
            con.setUseCaches(false);
            con.setRequestProperty("Content-Type", "application/x-www-form-urlencoded; charset=UTF-8");
            String urlParameters = "tenderId="+tenderId;
            DataOutputStream wr = new DataOutputStream(con.getOutputStream());
            wr.writeBytes(urlParameters);
            wr.flush();
            wr.close();
            int responseCode = con.getResponseCode();
            if(responseCode==200){
                BufferedReader in = new BufferedReader(
                new InputStreamReader(con.getInputStream()));
                String inputLine;
                StringBuffer response = new StringBuffer();
                while ((inputLine = in.readLine()) != null) {
                    response.append(inputLine);
                }
                in.close();
                tenderStatus =  new JSONObject(response.toString());
                status = tenderStatus.has("cstatus");
            }
        }catch(Exception e){
            System.out.println("error at checkTenderStatus function :"+e); 
        }
        
       return status;
    }
    private JSONObject checkValidIssuer(String Issuer,String certAliasSerialjson){
        JSONObject validIssuer = null;
        try{
            resourceBundle = ResourceBundle.getBundle("resource.project");
	    URL urlObj = new URL(resourceBundle.getString("validateIssuerURL"));
            System.setProperty("jsse.enableSNIExtension", "false");
	    HttpsURLConnection con = (HttpsURLConnection)urlObj.openConnection();
            //HttpURLConnection con = (HttpURLConnection)urlObj.openConnection();
            //add reuqest header
            con.setRequestMethod("POST");
            //con.setRequestProperty("Accept", "application/json");
            con.setReadTimeout(0);
            con.setDoInput(true);
            con.setDoOutput(true);
            con.setUseCaches(false);
            con.setRequestProperty("Content-Type", "application/x-www-form-urlencoded; charset=UTF-8");
            String urlParameters = "Issuer="+Issuer+"&certAliasSerialjson="+certAliasSerialjson;
            DataOutputStream wr = new DataOutputStream(con.getOutputStream());
            wr.writeBytes(urlParameters);
            wr.flush();
            wr.close();
            int responseCode = con.getResponseCode();
            if(responseCode==200){
                BufferedReader in = new BufferedReader(
                new InputStreamReader(con.getInputStream()));
                String inputLine;
                StringBuffer response = new StringBuffer();
                while ((inputLine = in.readLine()) != null) {
                    response.append(inputLine);
                }
                in.close();
                validIssuer =  new JSONObject(response.toString());
                if(validIssuer.length() == 0){
                    JOptionPane.showMessageDialog(null,"Please try again later as service not available.", "Service is not available", 1);
                }
            }else{
                JOptionPane.showMessageDialog(null,"Please try later as service not available.", "Service is not available", 1);
            }
        }catch(Exception e){
            System.out.println("error at checkValidIssuer function :"+e);   
        }
        return validIssuer;
    }
    private void loadCerti(){
        try{
           Certutility.getCertificateInformation(2);
           certAliasMap.put(0,"-- please select certificate --");
           Combomodel.insertElementAt("-- please select certificate --", 0);
            if(Certutility.openKeyStore("MY", "")){
                 String commaSeperatedIssuer = "";
                 iCertCount = Certutility.getCertificateCount();
                 //JOptionPane.showMessageDialog(null,"certcount"+iCertCount, "iCertCount", 1);
                 int encCert = 0;
                 Date datenow = new Date();
                 for(int j  =1;j<=iCertCount;j++){
                    certAlias = Certutility.getCertificateAlias(j);
                    Certutility.selectCertificate(certAlias);
                    certAliasSerial.put(j+"",certAlias+"```"+Certutility.getCertificateInformation(2).toString());
                    if(!commaSeperatedIssuer.contains(Certutility.getCertificateInformation(1)+"===")){
                        if(j!=(iCertCount)){
                            commaSeperatedIssuer = commaSeperatedIssuer+Certutility.getCertificateInformation(1)+"===";
                        }else{
                            commaSeperatedIssuer = commaSeperatedIssuer+Certutility.getCertificateInformation(1);
                        }
                    }
                 }
                 if(commaSeperatedIssuer != ""){
                    JSONObject validaIssuer =checkValidIssuer(commaSeperatedIssuer,certAliasSerial.toString());
                    for(int i = 1;i<=iCertCount;i++){
                       certAlias = Certutility.getCertificateAlias(i);
                       Certutility.selectCertificate(certAlias);
                       Date date = new SimpleDateFormat("EEE MMM dd HH:mm:ss Z yyyy").parse(Certutility.getCertificateInformation(6).replace("UTC+", "+"));
                       if (!Certutility.getCertificateInformation(7).equals("2") && (datenow.compareTo(date) != 1)&&validaIssuer.has(certAlias) && validaIssuer.has(Certutility.getCertificateInformation(1))){
                            certAliasMap.put(i-encCert,certAlias);
                            Combomodel.insertElementAt(certAlias+"   -(Active)", (i-encCert));
                       }else if(Certutility.getCertificateInformation(7).equals("2")){
                            certAliasMap.put(i-encCert,certAlias);
                            Combomodel.insertElementAt(certAlias+"   -(Encryption Certificate)", (i-encCert));
                       }else if ((datenow.compareTo(date) == 1)){
                            certAliasMap.put(i-encCert,certAlias);
                            Combomodel.insertElementAt(certAlias+"   -(Expired)", (i-encCert));
                       }else if(!validaIssuer.has(certAlias)){
                            certAliasMap.put(i-encCert,certAlias);
                            Combomodel.insertElementAt(certAlias+"   -(Revoked)", (i-encCert));
                       }else if(!validaIssuer.has(Certutility.getCertificateInformation(1))){
                            certAliasMap.put(i-encCert,certAlias);
                            Combomodel.insertElementAt(certAlias+"   -(Invalid Issuer)", (i-encCert));
                       }else{
                           encCert++;
                       }
                    }
                 }
            }
        }catch(Exception e){
            System.out.println("error at loadCerti function :"+e);
        }
    }
    private void showEmptyTable(){
        jTable1.getModel().setValueAt("", 0, 1);
        jTable1.getModel().setValueAt("", 1, 1);
        jTable1.getModel().setValueAt("", 2, 1);
        jTable1.getModel().setValueAt("", 3, 1);
        jTable1.getModel().setValueAt("", 4, 1);
        jTable1.getModel().setValueAt("", 5, 1);
        jPanel3.setVisible(true);
    }
    
    private void jButton1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton1ActionPerformed
       JFileChooser chooser = new JFileChooser();
        // optionally set chooser options ...
//                chooser.setCurrentDirectory(new File("C:\\"));
//        Action details = chooser.getActionMap().get("Go Up");
//        details.actionPerformed(null);
//        details.actionPerformed(null);
        chooser.setFileSelectionMode(JFileChooser.FILES_ONLY);
        FileNameExtensionFilter filter = new FileNameExtensionFilter("pdf files only", "pdf");
        chooser.setFileFilter(filter);
        chooser.setMultiSelectionEnabled(true);
        if (chooser.showOpenDialog(this) == JFileChooser.FILES_ONLY && chooser.getSelectedFiles() != null) {
            File[] selectedFile = chooser.getSelectedFiles();
            if(model.getSize()<10 && selectedFile.length <=10){
                for(int i = 0; i<selectedFile.length;i++){
                    try {
                        String strSelectedFiles = "";
                        boolean isFileExists = false;
                        if(model.getSize() != 0 || selectedFile.length != 0){
                            for (int iCnt = 0; iCnt <model.getSize(); iCnt++)
                            {
                                if(model.get(iCnt).toString().equals(selectedFile[i].getPath().toString())){
                                    strSelectedFiles = selectedFile[i].getPath().toString() +"\n";
                                    isFileExists = true;
                                }
                            }
                        }
                        boolean isNotPDF = !selectedFile[i].getPath().endsWith(".pdf");
                        if(isNotPDF){
                            JOptionPane.showMessageDialog(null,"Please select PDF file.", "Not a pdf File(s)", 1);
                        }else{
                            try{
                                PdfReader reader = new PdfReader(selectedFile[i].getPath());
                                AcroFields acroFields = reader.getAcroFields();
                                File file = new File(selectedFile[i].getPath());
                                double size = (double) file.length() /(1024 * 1024);
                                String pathName = selectedFile[i].getPath()+"`(Size:"+(new DecimalFormat("##.##").format(size))+"MB)";
                                if(size >= (double)50.0){
                                    pathName = pathName+"`(File size exceeded:50MB)";
                                }
                                if (selectedFile[i].isFile() && (!isFileExists) && acroFields.getSignatureNames().isEmpty()) {
                                    model.add(model.size(), pathName);
                                }else if(isFileExists && !strSelectedFiles.equals("")){
                                    JOptionPane.showMessageDialog(null, new StringBuilder().append(strSelectedFiles).append(" above listed file(s) are already available in the list.").toString(), "Duplicate File(s)", 1);
                                }else if(!acroFields.getSignatureNames().isEmpty()){
                                    JOptionPane.showMessageDialog(null,"Selected document is digitally signed. Please select other document", "Invalid PDF", 1);
                                }   
                            }catch (Exception ex){
                               JOptionPane.showMessageDialog(null,"selected PDF is password protected,kindly select unprotected PDF file to sign.", "Password protected PDF", 0); 
                            }
                        }
                    } catch (Exception ex) {
                        Logger.getLogger(PDFSigner.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
            }else {
                JOptionPane.showMessageDialog(null,"You can select at the most 10 files at a time.", "File limit", 0);
            }
            // read  and/or display the file somehow. ....
        }
    }//GEN-LAST:event_jButton1ActionPerformed

    private void jButton2ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton2ActionPerformed
        if (model.getSize() == 0) {
            JOptionPane.showMessageDialog(null, "No files available in the list","File Selection Error", 0);
        } else if (jList1.getSelectedIndex() < 0) {
            JOptionPane.showMessageDialog(null, "Select file from list", "Remove File Error", 0);
        }else {
            model.remove(jList1.getSelectedIndex());
        }
    }//GEN-LAST:event_jButton2ActionPerformed

    private void jButton3ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton3ActionPerformed
        JFileChooser f = new JFileChooser();
//        f.setCurrentDirectory(new File("C:\\"));
//        Action details = f.getActionMap().get("Go Up");
//        details.actionPerformed(null);
//        details.actionPerformed(null);
        f.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
        f.showSaveDialog(null);
        jTextField1.setText(f.getSelectedFile().getPath());
        jTextField1.setEditable(false);
    }//GEN-LAST:event_jButton3ActionPerformed
    private boolean checkTenderIdFormat(String tenderId){
        tenderId = tenderId.replace(" ", ""); 
        return tenderId.matches("[0-9]{1,10}");
    }
    private void jButton4ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton4ActionPerformed
        // TODO add your handling code here:
        String tenderID = jTextField4.getText();
        boolean isTenderPublished = false;
        boolean validTenderIdFormat = checkTenderIdFormat(tenderID);
        if(validTenderIdFormat){
            isTenderPublished = checkTenderStatus(tenderID);
        }
       //if(jTextField1.getText().isEmpty() == false && (model.getSize() != 0) && (jComboBox1.getSelectedIndex() != -1) && !(jTextField3.getText().length() >49) && (jComboBox1.getSelectedIndex() != 0) && tenderID.isEmpty() == false && validTenderIdFormat && isTenderPublished){
       if(jTextField1.getText().isEmpty() == false && (model.getSize() != 0) && (jComboBox1.getSelectedIndex() != -1) && (jComboBox1.getSelectedIndex() != 0)){
           int fileChoose = model.size();
            System.out.println("fileChoose"+fileChoose); 
           String  srcFile ="";
           String destFolder =  jTextField1.getText();
           boolean status = false;
           StringBuilder stringBuilder = new StringBuilder();
           stringBuilder.append("Problem in Source File List \n");
           int isSigned = 0;
           int isExceededLimit = 0;
           for(int i=0; i< fileChoose ; i++){
              srcFile = model.get(i).toString();
              if(!srcFile.contains(")`(File size exceeded:50MB)")){
                srcFile = srcFile.substring(0, srcFile.indexOf("`(Size:"));
                status = sign(srcFile ,jComboBox2.getSelectedItem().toString() , destFolder);
                if(!status){
                    stringBuilder.append(srcFile + "\n");
                }
                model.set(i, "");
                isSigned++;
                
                status = false;
              }else if(srcFile.contains(")`(File size exceeded:50MB)")){
                  isExceededLimit++;
                  if(isExceededLimit==1){
                    JOptionPane.showMessageDialog(null,"System will only sign file with allowable size(50MB).", "File size exceeds limit", 0);
                 }
              }
           }
           if((isExceededLimit==0) && (isSigned>0)){
                JOptionPane.showMessageDialog(null," Selected PDF document(s) are signed and are stored on "+new StringBuilder().append(jTextField1.getText()).toString(), "Please wait until process completion.", 1);
            }
           while(model.contains("")){
               model.removeElement("");
           }
           if(isExceededLimit==0){
                backToInitial();
           }
       }else if (jTextField3.getText().length() >49){
           JOptionPane.showMessageDialog(null,"please enter less than 50 characters for remarks", "Remarks is too long.", 0);
       }else if(jTextField1.getText().isEmpty()){
           JOptionPane.showMessageDialog(null, "please select path first", "No path selected", 0);
       }else if(model.getSize() == 0){
           JOptionPane.showMessageDialog(null, "please select files first", "No files selected", 0);
       }else if ((jComboBox1.getSelectedIndex() == -1) || (jComboBox1.getSelectedIndex() == 0)){
           JOptionPane.showMessageDialog(null,"please select certificate first", "certificate not selected", 0);
       }
//else if (tenderID.isEmpty()){
//           JOptionPane.showMessageDialog(null,"please enter tenderId.", "TenderId is mandatory", 0);
//       }else if (!validTenderIdFormat){
//           JOptionPane.showMessageDialog(null,"please enter only numeric values (0-9)", "Invalid TenderId format", 0);
//       }else if (!isTenderPublished){
//           JOptionPane.showMessageDialog(null,"Entered tender is not published.", "Tender not published", 0);
//       }
    }//GEN-LAST:event_jButton4ActionPerformed

    private void jComboBox1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jComboBox1ActionPerformed
        // TODO add your handling code here:
        //jLabel5.setText("<html> Subject :");

        //jLabel6.setText("Issuer :");

        //jLabel7.setText("Valid From :");

        //jLabel8.setText("Valid To :");

        //jLabel9.setText("Serial :");

       // jLabel10.setText("Key usage :");
        //JOptionPane.showMessageDialog(null, msg, "selected file", 0);
         if (jComboBox1.getSelectedIndex() == 0) {
            //jPanel1.setVisible(false);
            showEmptyTable();
            //JOptionPane.showMessageDialog(null, "Any certificate is not selected", "certificate not selected", 0);   
        }else if (jComboBox1.getSelectedIndex() != 0){
            //Combomodel.getElementAt(jComboBox1.getSelectedIndex());
            String comboAlias = (String)Combomodel.getElementAt(jComboBox1.getSelectedIndex());
            certAlias = certAliasMap.get(jComboBox1.getSelectedIndex());
            if(!(certAlias+"   -(Active)").equals(comboAlias)){
                if(comboAlias.contains("   -(Encryption Certificate)")){
                    //jPanel3.setVisible(false);
                    showEmptyTable();
                    jComboBox1.setSelectedIndex(0);
                     JOptionPane.showMessageDialog(null,"Selected certificate is Encryption certificate", "Invalid Certificate", 0);
                }else if(comboAlias.contains("   -(Expired)")){
                    //jPanel3.setVisible(false);
                    showEmptyTable();
                    jComboBox1.setSelectedIndex(0);
                     JOptionPane.showMessageDialog(null,"Selected certificate is Expired", "Invalid Certificate", 0);
                }else if(comboAlias.contains("   -(Invalid Issuer)")){
                    //jPanel3.setVisible(false);
                    showEmptyTable();
                    jComboBox1.setSelectedIndex(0);
                     JOptionPane.showMessageDialog(null,"Selected certificate has Invalid Issuer", "Invalid Certificate", 0);
                }else if(comboAlias.contains("   -(Revoked)")){
                    //jPanel3.setVisible(false);
                    showEmptyTable();
                    jComboBox1.setSelectedIndex(0);
                     JOptionPane.showMessageDialog(null,"Selected certificate is Revoked", "Invalid Certificate", 0);
                }else{
                    //jPanel3.setVisible(false);
                    showEmptyTable();
                    jComboBox1.setSelectedIndex(0);
                    JOptionPane.showMessageDialog(null,"Selected certificate is not valid to sign a PDF", "Invalid Certificate", 0);
                }
            }else{
                Certutility.selectCertificate(certAlias);
                String strUsages = "Key Encipherment";
                if (Certutility.getCertificateInformation(7).equals("1")){
                    strUsages = "Digital Signature";
                }else if (Certutility.getCertificateInformation(7).equals("3")) {
                    strUsages = "Digital Signature,  Key Encipherment";
                }
                String subject = Certutility.getCertificateInformation(0)+"</html>";
                //jLabel5.setText(jLabel5.getText()+subject);
                //jLabel6.setText(jLabel6.getText()+Certutility.getCertificateInformation(1));
                //jLabel7.setText(jLabel7.getText()+Certutility.getCertificateInformation(5));
                //jLabel8.setText(jLabel8.getText()+Certutility.getCertificateInformation(6));
                //jLabel9.setText(jLabel9.getText()+Certutility.getCertificateInformation(2));
                //jLabel10.setText(jLabel10.getText()+strUsages);
                //jPanel1.setVisible(true);
                jTable1.getModel().setValueAt(Certutility.getCertificateInformation(0), 0, 1);
                jTable1.getModel().setValueAt(Certutility.getCertificateInformation(1), 1, 1);
                jTable1.getModel().setValueAt(Certutility.getCertificateInformation(5), 2, 1);
                jTable1.getModel().setValueAt(Certutility.getCertificateInformation(6), 3, 1);
                jTable1.getModel().setValueAt(Certutility.getCertificateInformation(2), 4, 1);
                jTable1.getModel().setValueAt(strUsages, 5, 1);
                jPanel3.setVisible(true);
            }
        }
    }//GEN-LAST:event_jComboBox1ActionPerformed

    private void jComboBox2ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jComboBox2ActionPerformed
        jComboBox2.getSelectedItem();
    }//GEN-LAST:event_jComboBox2ActionPerformed

    private void jComboBox3ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jComboBox3ActionPerformed
        // TODO add your handling code here:
    }//GEN-LAST:event_jComboBox3ActionPerformed

    private void jCheckBox1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jCheckBox1ActionPerformed
        // TODO add your handling code here:
        if(jCheckBox1.isSelected()){
            jPanel2.setVisible(true);
        }else{
            jTextField2.setText("");
            jPanel2.setVisible(false);
        }
    }//GEN-LAST:event_jCheckBox1ActionPerformed

    private void jButton5ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton5ActionPerformed
        // TODO add your handling code here:
        JFileChooser f1 = new JFileChooser();
        f1.setFileSelectionMode(JFileChooser.FILES_ONLY);
        FileNameExtensionFilter filter = new FileNameExtensionFilter("Images(png,jpg,gif,bmp)", "jpg", "png", "gif", "bmp");
        f1.setFileFilter(filter);
        f1.showSaveDialog(null);
        jTextField2.setText(f1.getSelectedFile().getPath());
        String imagePath = jTextField2.getText();
        if(!imagePath.isEmpty() && !"".equals(imagePath)){
            if((imagePath.toLowerCase().endsWith(".png") ||imagePath.toLowerCase().endsWith(".bmp") ||imagePath.toLowerCase().endsWith(".jpg") ||imagePath.toLowerCase().endsWith(".gif")) == false){
                JOptionPane.showMessageDialog(null,"only .png,.bmp,.jpg,.gif file formats are allowed", "Not a valid file format", 0);
                jTextField2.setText("");
            }else{
                File file = new File(imagePath);
                double size = (double) file.length() / 1024;
                if(size >= (double)10.0){
                    JOptionPane.showMessageDialog(null,"file size should be less than 10 kb", "file size", 0);
                    jTextField2.setText("");
                }
            }
        }
    }//GEN-LAST:event_jButton5ActionPerformed

    private void jTextField4ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jTextField4ActionPerformed
        // TODO add your handling code here:
    }//GEN-LAST:event_jTextField4ActionPerformed

    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) {
        /* Set the Nimbus look and feel */
        //<editor-fold defaultstate="collapsed" desc=" Look and feel setting code (optional) ">
        /* If Nimbus (introduced in Java SE 6) is not available, stay with the default look and feel.
         * For details see http://download.oracle.com/javase/tutorial/uiswing/lookandfeel/plaf.html 
         */
        try {
            for (javax.swing.UIManager.LookAndFeelInfo info : javax.swing.UIManager.getInstalledLookAndFeels()) {
                if ("Nimbus".equals(info.getName())) {
                    javax.swing.UIManager.setLookAndFeel(info.getClassName());
                    break;
                }
            }
        } catch (ClassNotFoundException ex) {
            java.util.logging.Logger.getLogger(PDFSigner.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        } catch (InstantiationException ex) {
            java.util.logging.Logger.getLogger(PDFSigner.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        } catch (IllegalAccessException ex) {
            java.util.logging.Logger.getLogger(PDFSigner.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        } catch (javax.swing.UnsupportedLookAndFeelException ex) {
            java.util.logging.Logger.getLogger(PDFSigner.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        } catch (Exception e){
            java.util.logging.Logger.getLogger(PDFSigner.class.getName()).log(java.util.logging.Level.SEVERE, null, e);
        }
        //</editor-fold>

        /* Create and display the form */
        java.awt.EventQueue.invokeLater(new Runnable() {
            public void run() {
                new PDFSigner().setVisible(true);
            }
        });
    }

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton jButton1;
    private javax.swing.JButton jButton2;
    private javax.swing.JButton jButton3;
    private javax.swing.JButton jButton4;
    private javax.swing.JButton jButton5;
    private javax.swing.JCheckBox jCheckBox1;
    private javax.swing.JCheckBoxMenuItem jCheckBoxMenuItem1;
    private javax.swing.JCheckBoxMenuItem jCheckBoxMenuItem2;
    private javax.swing.JCheckBoxMenuItem jCheckBoxMenuItem3;
    private javax.swing.JComboBox<String> jComboBox1;
    private DefaultComboBoxModel Combomodel = new DefaultComboBoxModel();
    private javax.swing.JComboBox<String> jComboBox2;
    private javax.swing.JComboBox<String> jComboBox3;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel11;
    private javax.swing.JLabel jLabel12;
    private javax.swing.JLabel jLabel13;
    private javax.swing.JLabel jLabel14;
    private javax.swing.JLabel jLabel15;
    private javax.swing.JLabel jLabel16;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JLabel jLabel4;
    private javax.swing.JList<String> jList1;
    private DefaultListModel model = new DefaultListModel();
    private javax.swing.JMenu jMenu1;
    private javax.swing.JMenuItem jMenuItem1;
    private javax.swing.JMenuItem jMenuItem2;
    private javax.swing.JMenuItem jMenuItem3;
    private javax.swing.JMenuItem jMenuItem4;
    private javax.swing.JMenuItem jMenuItem5;
    private javax.swing.JMenuItem jMenuItem6;
    private javax.swing.JMenuItem jMenuItem7;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JPanel jPanel3;
    private javax.swing.JPopupMenu jPopupMenu1;
    private javax.swing.JRadioButtonMenuItem jRadioButtonMenuItem1;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JScrollPane jScrollPane2;
    private javax.swing.JScrollPane jScrollPane3;
    private javax.swing.JTable jTable1;
    private javax.swing.JTextArea jTextArea1;
    private javax.swing.JTextField jTextField1;
    private javax.swing.JTextField jTextField2;
    private javax.swing.JTextField jTextField3;
    private javax.swing.JTextField jTextField4;
    // End of variables declaration//GEN-END:variables

    private void setIcon() {
        setIconImage(Toolkit.getDefaultToolkit().getImage(getClass().getResource("PTLogo2.png")));
    }
}



